//adjustable wrench

#include "wrench/wrench_material.inc"  
#include "shapes3.inc"

#macro coil (radA,radB,turns,h,objType)
  
    #declare sPoint = sphere {<0,0,0>, radB }                              
    #declare pointDataCount = 24 ;
    #declare pointArray = array[pointDataCount] ;
    #declare pointArray[0] = <0.000, 0.000, 1.000>  ;
    #declare pointArray[1] = <-0.258, 0.000, 0.965>  ;
    #declare pointArray[2] = <-0.500, 0.000, 0.866>  ;
    #declare pointArray[3] = <-0.707, 0.000, 0.707>  ;
    #declare pointArray[4] = <-0.866, 0.000, 0.500>  ;
    #declare pointArray[5] = <-0.965, 0.000, 0.258>  ;
    #declare pointArray[6] = <-1.000, 0.000, 0.000>  ;
    #declare pointArray[7] = <-0.965, 0.000, -0.258>  ;
    #declare pointArray[8] = <-0.866, 0.000, -0.500>  ;
    #declare pointArray[9] = <-0.707, 0.000, -0.707>  ;
    #declare pointArray[10] = <-0.500, 0.000, -0.866>  ;
    #declare pointArray[11] = <-0.258, 0.000, -0.965>  ;
    #declare pointArray[12] = <0.000, 0.000, -1.000>  ;
    #declare pointArray[13] = <0.258, 0.000, -0.965>  ;
    #declare pointArray[14] = <0.500, 0.000, -0.866>  ;
    #declare pointArray[15] = <0.707, 0.000, -0.707>  ;
    #declare pointArray[16] = <0.866, 0.000, -0.500>  ;
    #declare pointArray[17] = <0.965, 0.000, -0.258>  ;
    #declare pointArray[18] = <0.999, 0.000, 0.000>  ;
    #declare pointArray[19] = <0.965, 0.000, 0.258>  ;
    #declare pointArray[20] = <0.866, 0.000, 0.500>  ;
    #declare pointArray[21] = <0.707, 0.000, 0.707>  ;
    #declare pointArray[22] = <0.500, 0.000, 0.866>  ;
    #declare pointArray[23] = <0.258, 0.000, 0.965>  ; 
    
   
    #if (objType="plotCoil")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        sphere_sweep {
        cubic_spline
        c * turns,
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                nPos * radA , radB
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
        tolerance 0.000001
        }
    #end 
    
    #if (objType="plotPoints")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                object { sPoint translate nPos * radA }
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
    #end 
#end




#declare sz=.6;
#declare part_1 =
sphere_sweep {
     cubic_spline
     12,
     <2.914, 3.238, 0> , sz
     <2.914, 3.238, 0> , sz
     <2.818, 8.490, 0> , sz
     <2.759, 13.149, 0> , sz
     <2.661, 18.786, 0> , sz
     <2.539, 24.425, 0> , sz
     <2.469, 29.711, 0> , sz
     <2.351, 35.021, 0> , sz
     <2.234, 40.096, 0> , sz
     <2.187, 43.103, 0> , sz
     <2.180, 44.124, 0> , sz
     <2.180, 44.124, 0> , sz
     tolerance 0.000001
     }
     
        
#declare sz=.6;
#declare part_2 =
sphere_sweep {
     cubic_spline
     12,
     <-2.914, 3.238, 0> , sz
     <-2.914, 3.238, 0> , sz
     <-2.818, 8.490, 0> , sz
     <-2.759, 13.149, 0> , sz
     <-2.661, 18.786, 0> , sz
     <-2.539, 24.425, 0> , sz
     <-2.469, 29.711, 0> , sz
     <-2.351, 35.021, 0> , sz
     <-2.234, 40.096, 0> , sz
     <-2.187, 43.103, 0> , sz
     <-2.180, 44.124, 0> , sz
     <-2.180, 44.124, 0> , sz
     tolerance 0.000001
     }
     
     
#declare body_1 =
prism {
    linear_spline
    -.35, .35, 11,
    <2.916,3.207>,
    <2.190,5.088>,
    <-0.003,6.166>,
    <-2.277,5.068>,
    <-2.963,3.167>,
    <-2.208,44.133>,
    <-1.547,42.518>,
    <0.004,41.912>,
    <1.453,42.479>,
    <2.201,44.101>
    <2.916,3.207>
}

#declare part_3 =
sphere_sweep {
     cubic_spline
     20,
     <-2.180, 44.124, 0.000> , 0.500
     <-2.180, 44.124, 0.000> , 0.500
     <-2.462, 47.110, -0.000> , 0.647
     <-3.333, 49.509, -0.000> , 0.729
     <-4.579, 51.978, -0.000> , 0.885
     <-6.202, 54.659, -0.000> , 1.055
     <-8.012, 57.246, -0.000> , 1.224
     <-4.696, 58.563, -0.000> , 1.224
     <0.813, 60.708, -0.000> , 1.2
     <4.324, 62.122, -0.000> , 1.1
     <1.203, 69.437, -0.000> , 1
     <4.275, 68.023, -0.000> , 1.2
     <7.396, 65.390, -0.000> , 1.224
     <9.200, 61.586, -0.000> , 1.224
     <8.518, 58.221, -0.000> , 1.013
     <6.062, 54.327, -0.000> , 0.884
     <3.805, 50.433, -0.000> , 0.730
     <2.507, 47.103, -0.000> , 0.647
     <2.280, 44.124, -0.096> , 0.500
     <2.280, 44.124, -0.096> , 0.500
     tolerance 0.000001
     } 
  
     
#declare body_2 =
prism {
    linear_spline
    -1.224, 1.224, 24,
    <-2.170,44.124>,
    <-2.521,47.095>,
    <-3.814,50.429>,
    <-6.052,54.316>,
    <-8.518,58.236>,
    <-9.207,61.581>,
    <-7.397,65.378>,
    <-4.308,68.018>,
    <-1.205,69.461>,
    <-4.308,62.112>,
    <-0.824,60.710>,
    <4.686,58.560>,
    <8.007,57.226>,
    <6.197,54.641>,
    <4.591,51.960>,
    <3.339,49.510>,
    <2.451,47.119>,
    <2.167,44.126>,
    <1.789,45.315>,
    <0.978,46.056>,
    <-0.013,46.292>,
    <-1.250,45.898>,
    <-1.864,45.205>
    <-2.170,44.124>
}

#declare void_1 =
prism {
    linear_spline
    -20, 20, 6,
    <-9.958,56.574>,
    <3.183,61.648>,
    <3.848,63.367>,
    <0.660,70.908>,
    <-12.731,67.858>
    <-9.958,56.574>  
    rotate <-90,0,0>

}

#declare void_2 = box { <-12,0,-.3>,<8,6,.3> }

#declare void_notch =
prism {
    linear_spline
    -20, 20, 6,
    <-10.000,20.000>,
    <-10.000,5.553>,
    <-8.138,3.9>,
    <20.415,3.9>,
    <20.415,20.000>
    <-10.000,20.000> 
    rotate <-90,0,0>
}


#declare void_3 =
#declare rad = .5 ;
union { 
    #declare sc = <3.322, 3.322, 1> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> rotate <0,0,23> translate <-0.606, 53.753, -1.5> } 
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> rotate <0,0,23> translate <-0.606, 53.753, 1.5> } 
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, .2 , 0) scale <1.6,1.6,2> rotate <0,0,23> translate <-0.606, 53.753, 0> } 
    }
      


#declare part_4 =
difference {
   sphere { <0,0,0>, 1 scale <16,16,5> }
   object { void_notch translate <1,0,0>} 
   plane {<0,1,0>, 0 translate <0,4,0> }
}



    
#declare wrench_A = 
union {
    union {
        torus {2.914, sz rotate <90,0,0> translate<0,3.238,0> } 
        difference {
            torus {2.180, sz rotate <90,0,0> translate<0,44.124,0> } 
            plane {<0,1,0>, 0  translate<0,44.124,0>}
        } 
        cylinder {<0,0,-.35>,<0,0,.35>, 2.180 translate<0,44.124,0> }     
        object { part_1 }   
        object { part_2 }
          
        difference {
            object { part_4 }
            plane {<0,0,1>,  0 translate <0,0,-.95 >} 
            plane {<0,0,-1>, 0 translate <0,0,.95> }  
            cylinder {<0,0,0>,<0,0,-1>,7 translate <-6.5,0,-.2> material {M_wrech_noise}} 
            cylinder {<0,0,0>,<0,0,1>,7 translate <-6.5,0, .2>material {M_wrech_noise} } 
            material {M_wrech_smooth}
            rotate <0,0,21> 
            translate <8.5,59.3,0>
            scale <1,1,.95>          
        }
       
        object { body_1 rotate <-90,0,0>}
        
        difference {
            union {
                object { part_3 }
                object { body_2 scale <-1,1,1> rotate <-90,0,0>}
            }
            plane {<0,0,1>,  0 translate <0,0,-.95 >    material {M_wrech_smooth}} 
            plane {<0,0,-1>, 0 translate <0,0,.95>      material {M_wrech_smooth}}
            plane {<0,-1,0>, 0 translate <0,70.5,0>     material {M_wrech_smooth}} 
            object { void_2 rotate <0,0,20> translate <0,56,0> material {M_wrech_smooth}}
            object { void_1 translate<.2,0,0> material {M_wrech_smooth}} 
            cylinder {<-20,0,0>,<20,0,0>, 15 scale <1,3.1,1> rotate <0,0,20> translate <0,44,-15.57> }
            cylinder {<-20,0,0>,<20,0,0>, 15 scale <1,3.1,1> rotate <0,0,20> translate <0,44, 15.57> }
            cylinder {<-10,0,0>,<20,0,0>, .95 scale <1,1,.75> rotate <0,0,20> translate <0,58.5, 0> }
            object { void_3 }
        } 
        scale <1,1,1.75> 
        material {M_wrech_noise}
    }
    union {  
        cylinder {<-9.5,0,0>,<6,0,0>, .9  }
        sphere { <0,0,0>, .9 scale <.5,1,1> translate <-9.5,0,0> } 
        rotate <0,0,20> translate <0,58.5, 0>
        material {M_wrech_smooth}
    }
    
    object { coil(1.4,1,4,9,"plotCoil") scale <1,.4,1> rotate <0,0,-69> translate <-3,53,0> material {M_wrech_noise}}
    cylinder {<-5,0,0>,<3,0,0>, 1.3 rotate <0,0,23> translate <0,54,0> material {M_wrech_smooth} }
    
}  

